<?php

/**
 * Breadcrumbs for Xotric Theme.
 *
 * @package     xotric
 * @author      ThemeAdapt
 * @copyright   Copyright (c) 2023, ThemeAdapt
 * @link        https://themeadapt.com
 * @since       xotric 1.0.0
 */


function xotric_breadcrumb_func()
{
    global $post;
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    if (is_front_page() && is_home()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'xotric'));
        $breadcrumb_class = 'home_front_page';
    }
    elseif (is_front_page()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'xotric'));
        $breadcrumb_show = 0;
    }
    elseif (is_home()) {
        if (get_option('page_for_posts')) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    }
    elseif (is_single() && 'post' == get_post_type()) {
        $title = get_the_title();
        $breadcrumb_class = 'details-breadcrumb';
    }
    elseif (is_single() && 'project' == get_post_type()) {
        return;
    }
    elseif (is_search()) {
        $title = esc_html__('Search Results for : ', 'xotric') . get_search_query();
    }
    elseif (is_404()) {
        $title = esc_html__('Page not Found', 'xotric');
    }
    elseif (is_archive()) {
        $title = get_the_archive_title();
    }
    else {
        $title = get_the_title();
    }

    $_id = get_the_ID();

    if (is_single() && 'product' == get_post_type()) {
        $_id = $post->ID;
    } elseif (is_home() && get_option('page_for_posts')) {
        $_id = get_option('page_for_posts');
    }

    $is_breadcrumb = function_exists('get_field') ? get_field('is_it_invisible_breadcrumb', $_id) : '';
    if (!empty($_GET['s'])) {
        $is_breadcrumb = null;
    }

    if (empty($is_breadcrumb) && $breadcrumb_show == 1) {

        // get_theme_mod
        $breadcrumb_hide_default = get_theme_mod('breadcrumb_hide_default', true);
        $breadcrumb_info_switch = get_theme_mod('breadcrumb_info_switch', false);
        $breadcrumb_shape_hide = get_theme_mod('breadcrumb_shape_hide', false);
        $breadcrumb_col = $breadcrumb_shape_hide ? '7' : '12';

        $xotric_shape01 = get_template_directory_uri() . '/assets/img/images/breadcrumb_shape01.png';
        $breadcrumb_shape_one = get_theme_mod('breadcrumb_shape_one', $xotric_shape01);

        $xotric_shape02 = get_template_directory_uri() . '/assets/img/images/breadcrumb_shape02.png';
        $breadcrumb_shape_two = get_theme_mod('breadcrumb_shape_two', $xotric_shape02);

?>

        <?php if (!empty($breadcrumb_hide_default)) : ?>
            <!-- breadcrumb-area -->
            <section class="breadcrumb-area-two <?php print esc_attr($breadcrumb_class); ?>">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-<?php echo esc_attr($breadcrumb_col); ?>">
                            <div class="breadcrumb-content-two">
                                <h2 class="title"><?php echo wp_kses_post($title); ?></h2>
                                <?php if (!empty($breadcrumb_info_switch)) : ?>
                                    <nav aria-label="breadcrumb" class="breadcrumb">
                                        <?php if (function_exists('bcn_display')) {
                                            bcn_display();
                                        } ?>
                                    </nav>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if (!empty($breadcrumb_shape_hide)) : ?>
                            <div class="col-lg-5">
                                <div class="breadcrumb-shape">

                                    <?php if (!empty($breadcrumb_shape_one)) : ?>
                                        <img data-parallax='{"x" : 0 , "y" : 100 }' src="<?php echo esc_url($breadcrumb_shape_one) ?>" alt="<?php print esc_attr__('Shape', 'xotric'); ?>">
                                    <?php endif; ?>

                                    <?php if (!empty($breadcrumb_shape_two)) : ?>
                                        <img src="<?php echo esc_url($breadcrumb_shape_two) ?>" alt="<?php print esc_attr__('Shape', 'xotric'); ?>">
                                    <?php endif; ?>

                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </section>
            <!-- breadcrumb-area-end -->
        <?php endif; ?>

<?php
    }
}

add_action('xotric_before_main_content', 'xotric_breadcrumb_func');