<?php

/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package xotric
 */


/**
 *
 * Xotric Header
 */

function xotric_check_header()
{
    $xotric_header_style = function_exists('get_field') ? get_field('header_style') : NULL;
    $xotric_default_header_style = get_theme_mod('choose_default_header', 'header-style-1');

    if ($xotric_header_style == 'header-style-1' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-1');
    }
    elseif ($xotric_header_style == 'header-style-2' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-2');
    }
    elseif ($xotric_header_style == 'header-style-3' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-3');
    }
    elseif ($xotric_header_style == 'header-style-4' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-4');
    }
    elseif ($xotric_header_style == 'header-style-5' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-5');
    }
    elseif ($xotric_header_style == 'header-style-6' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-6');
    }
    else {
        /** Default Header Style **/
        if ($xotric_default_header_style == 'header-style-2') {
            get_template_part('template-parts/header/header-2');
        }
        elseif ($xotric_default_header_style == 'header-style-3') {
            get_template_part('template-parts/header/header-3');
        }
        elseif ($xotric_default_header_style == 'header-style-4') {
            get_template_part('template-parts/header/header-4');
        }
        elseif ($xotric_default_header_style == 'header-style-5') {
            get_template_part('template-parts/header/header-5');
        }
        elseif ($xotric_default_header_style == 'header-style-6') {
            get_template_part('template-parts/header/header-6');
        }
        else {
            get_template_part('template-parts/header/header-1');
        }
    }
}
add_action('xotric_header_style', 'xotric_check_header', 10);


/**
 * [xotric_header_lang description]
 * @return [type] [description]
 */
function xotric_header_lang_default()
{
    $xotric_header_lang = get_theme_mod('xotric_header_lang', false);
    if ($xotric_header_lang) : ?>

        <ul>
            <li><a href="javascript:void(0)" class="lang__btn"><?php print esc_html__('English', 'xotric'); ?> <i class="fa-light fa-angle-down"></i></a>
                <?php do_action('xotric_language'); ?>
            </li>
        </ul>

    <?php endif; ?>
<?php
}

/**
 * [xotric_language_list description]
 * @return [type] [description]
 */
function _xotric_language($mar)
{
    return $mar;
}
function xotric_language_list()
{

    $mar = '';
    $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');
    if (!empty($languages)) {
        $mar = '<div class="dropdown-menu" aria-labelledby="dropdownMenuButton1">';
        foreach ($languages as $lan) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<a href="' . $lan['url'] . '" class="' . $active . '">' . $lan['translated_name'] . '</a>';
        }
        $mar .= '</div>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<div class="dropdown-menu" aria-labelledby="dropdownMenuButton1">';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__('🇷🇺 RU', 'xotric') . '</a>';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__('🇮🇳 IN', 'xotric') . '</a>';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__('🇹🇷 TR', 'xotric') . '</a>';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__('🇫🇷 FR', 'xotric') . '</a>';
        $mar .= ' </div>';
    }
    print _xotric_language($mar);
}
add_action('xotric_language', 'xotric_language_list');


// Header 01 Logo
function xotric_header_logo()
{ ?>
    <?php
    $xotric_logo = get_template_directory_uri() . '/assets/img/logo/logo.svg';
    $xotric_site_logo = get_theme_mod('logo', $xotric_logo);
    ?>
    <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($xotric_site_logo); ?>" style="max-height: <?php echo get_theme_mod('logo_size_adjust', '36px'); ?>" alt="<?php print esc_attr__('Logo', 'xotric'); ?>" />
    </a>
<?php
}

// Header 02 Logo
function xotric_header_two_logo()
{ ?>
    <?php
    $xotric_logo_black = get_template_directory_uri() . '/assets/img/logo/second_logo.svg';
    $xotric_second_logo = get_theme_mod('logo_two', $xotric_logo_black);
    ?>
    <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($xotric_second_logo); ?>" style="max-height: <?php echo get_theme_mod('logo_size_adjust', '36px'); ?>" alt="<?php print esc_attr__('Logo', 'xotric'); ?>" />
    </a>
<?php
}

// Header 03 Logo
function xotric_header_three_logo()
{ ?>
    <?php
    $xotric_logo_gradient = get_template_directory_uri() . '/assets/img/logo/third_logo.svg';
    $xotric_third_logo = get_theme_mod('logo_three', $xotric_logo_gradient);

    $header_sticky_logo = get_template_directory_uri() . '/assets/img/logo/black_logo.svg';
    $logo_four = get_theme_mod('logo_four', $header_sticky_logo);
    ?>
    <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($xotric_third_logo); ?>" style="max-height: <?php echo get_theme_mod('logo_size_adjust', '36px'); ?>" alt="<?php print esc_attr__('Logo', 'xotric'); ?>" />
    </a>

    <a class="sticky-logo d-none" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($logo_four); ?>" style="max-height: <?php echo get_theme_mod('logo_size_adjust', '36px'); ?>" alt="<?php print esc_attr__('Logo', 'xotric'); ?>" />
    </a>

<?php }

// Header 04 Logo
function xotric_header_four_logo()
{ ?>
    <?php
    $header_fourth_logo = get_template_directory_uri() . '/assets/img/logo/fourth_logo.svg';
    $xotric_fourth_logo = get_theme_mod('logo_five', $header_fourth_logo);
    ?>
    <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($xotric_fourth_logo); ?>" style="max-height: <?php echo get_theme_mod('logo_size_adjust', '36px'); ?>" alt="<?php print esc_attr__('Logo', 'xotric'); ?>" />
    </a>
<?php
}

// Header 05 Logo
function xotric_header_five_logo()
{ ?>
    <?php
    $header_fifth_logo = get_template_directory_uri() . '/assets/img/logo/fifth_logo.svg';
    $xotric_fifth_logo = get_theme_mod('logo_six', $header_fifth_logo);
    ?>
    <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($xotric_fifth_logo); ?>" style="max-height: <?php echo get_theme_mod('logo_size_adjust', '36px'); ?>" alt="<?php print esc_attr__('Logo', 'xotric'); ?>" />
    </a>
<?php
}

/**
 * [xotric_header_social_profiles description]
 * @return [type] [description]
 */
function xotric_header_social_profiles()
{
    $xotric_header_fb_url = get_theme_mod('xotric_header_fb_url', __('#', 'xotric'));
    $xotric_header_twitter_url = get_theme_mod('xotric_header_twitter_url', __('#', 'xotric'));
    $xotric_header_linkedin_url = get_theme_mod('xotric_header_linkedin_url', __('#', 'xotric'));
?>
    <ul>
        <?php if (!empty($xotric_header_fb_url)) : ?>
            <li><a href="<?php print esc_url($xotric_header_fb_url); ?>"><span><i class="flaticon-facebook"></i></span></a></li>
        <?php endif; ?>

        <?php if (!empty($xotric_header_twitter_url)) : ?>
            <li><a href="<?php print esc_url($xotric_header_twitter_url); ?>"><span><i class="flaticon-twitter"></i></span></a></li>
        <?php endif; ?>

        <?php if (!empty($xotric_header_linkedin_url)) : ?>
            <li><a href="<?php print esc_url($xotric_header_linkedin_url); ?>"><span><i class="flaticon-linkedin"></i></span></a></li>
        <?php endif; ?>
    </ul>

<?php
}

function xotric_footer_social_profiles()
{
    $xotric_footer_fb_url = get_theme_mod('xotric_footer_fb_url', __('#', 'xotric'));
    $xotric_footer_twitter_url = get_theme_mod('xotric_footer_twitter_url', __('#', 'xotric'));
    $xotric_footer_vimeo_url = get_theme_mod('xotric_footer_vimeo_url', __('#', 'xotric'));
    $xotric_footer_youtube_url = get_theme_mod('xotric_footer_youtube_url', __('#', 'xotric'));
?>

    <ul>
        <?php if (!empty($xotric_footer_fb_url)) : ?>
            <li>
                <a href="<?php print esc_url($xotric_footer_fb_url); ?>">
                    <i class="fab fa-facebook-square"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_footer_twitter_url)) : ?>
            <li>
                <a href="<?php print esc_url($xotric_footer_twitter_url); ?>">
                    <i class="fab fa-twitter"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_footer_vimeo_url)) : ?>
            <li>
                <a href="<?php print esc_url($xotric_footer_vimeo_url); ?>">
                    <i class="fab fa-vimeo-v"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_footer_youtube_url)) : ?>
            <li>
                <a href="<?php print esc_url($xotric_footer_youtube_url); ?>">
                    <i class="fab fa-youtube"></i>
                </a>
            </li>
        <?php endif; ?>
    </ul>
<?php
}

/**
 * [xotric_mobile_social_profiles description]
 * @return [type] [description]
 */
function xotric_mobile_social_profiles()
{
    $xotric_mobile_fb_url           = get_theme_mod('xotric_mobile_fb_url', __('#', 'xotric'));
    $xotric_mobile_twitter_url      = get_theme_mod('xotric_mobile_twitter_url', __('#', 'xotric'));
    $xotric_mobile_instagram_url    = get_theme_mod('xotric_mobile_instagram_url', __('#', 'xotric'));
    $xotric_mobile_linkedin_url     = get_theme_mod('xotric_mobile_linkedin_url', __('#', 'xotric'));
    $xotric_mobile_telegram_url      = get_theme_mod('xotric_mobile_telegram_url', __('#', 'xotric'));
?>

    <ul class="clearfix">
        <?php if (!empty($xotric_mobile_fb_url)) : ?>
            <li class="facebook">
                <a href="<?php print esc_url($xotric_mobile_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_mobile_twitter_url)) : ?>
            <li class="twitter">
                <a href="<?php print esc_url($xotric_mobile_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_mobile_instagram_url)) : ?>
            <li class="instagram">
                <a href="<?php print esc_url($xotric_mobile_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_mobile_linkedin_url)) : ?>
            <li class="linkedin">
                <a href="<?php print esc_url($xotric_mobile_linkedin_url); ?>"><i class="fab fa-linkedin-in"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($xotric_mobile_telegram_url)) : ?>
            <li class="telegram">
                <a href="<?php print esc_url($xotric_mobile_telegram_url); ?>"><i class="fab fa-telegram-plane"></i></a>
            </li>
        <?php endif; ?>
    </ul>

<?php
}


/**
 * [xotric_header_menu description]
 * @return [type] [description]
 */
function xotric_header_menu()
{
?>
    <?php
    wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Xotric_Navwalker_Class::fallback',
        'walker'         => new Xotric_Navwalker_Class,
    ]);
    ?>
<?php
}


/**
 * [xotric_hamburger_menu description]
 * @return [type] [description]
 */
function xotric_hamburger_menu()
{
?>
    <?php
    wp_nav_menu([
        'theme_location' => 'hamburger-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Xotric_Navwalker_Class::fallback',
        'walker'         => new Xotric_Navwalker_Class,
    ]);
    ?>
<?php
}

/**
 * [xotric_header_menu description]
 * @return [type] [description]
 */
function xotric_mobile_menu()
{ ?>
    <?php
    $xotric_menu = wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => false,
        'echo'           => false,
    ]);

    $xotric_menu = str_replace("menu-item-has-children", "menu-item-has-children has-children", $xotric_menu);
    echo wp_kses_post($xotric_menu);
    ?>
<?php
}

/**
 * [xotric_blog_mobile_menu description]
 * @return [type] [description]
 */
function xotric_blog_mobile_menu()
{ ?>
    <?php
    $xotric_menu = wp_nav_menu([
        'theme_location' => 'blog-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => false,
        'echo'           => false,
    ]);

    $xotric_menu = str_replace("menu-item-has-children", "menu-item-has-children has-children", $xotric_menu);
    echo wp_kses_post($xotric_menu);
    ?>
<?php
}

/**
 * [xotric_search_menu description]
 * @return [type] [description]
 */
function xotric_header_search_menu()
{ ?>
    <?php
    wp_nav_menu([
        'theme_location' => 'header-search-menu',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Xotric_Navwalker_Class::fallback',
        'walker'         => new Xotric_Navwalker_Class,
    ]);
    ?>
<?php
}

/**
 * [xotric_footer_menu description]
 * @return [type] [description]
 */
function xotric_footer_menu()
{
    wp_nav_menu([
        'theme_location' => 'footer-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Xotric_Navwalker_Class::fallback',
        'walker'         => new Xotric_Navwalker_Class,
    ]);
}


/**
 * [xotric_category_menu description]
 * @return [type] [description]
 */
function xotric_category_menu()
{
    wp_nav_menu([
        'theme_location' => 'category-menu',
        'menu_class'     => 'cat-submenu m-0',
        'container'      => '',
        'fallback_cb'    => 'Xotric_Navwalker_Class::fallback',
        'walker'         => new Xotric_Navwalker_Class,
    ]);
}

/**
 *
 * xotric footer
 */
add_action('xotric_footer_style', 'xotric_check_footer', 10);

function xotric_check_footer()
{

    $footer_show = 1;
    $is_footer = function_exists('get_field') ? get_field('is_it_invisible_footer') : '';
    if (!empty($_GET['s'])) {
        $is_footer = null;
    }

    if (empty($is_footer) && $footer_show == 1) {
        $xotric_footer_style = function_exists('get_field') ? get_field('footer_style') : NULL;
        $xotric_default_footer_style = get_theme_mod('choose_default_footer', 'footer-style-1');

        get_template_part('template-parts/footer/footer-1');
    }
}


// xotric_copyright_text
function xotric_copyright_text()
{
    print get_theme_mod('xotric_copyright', esc_html__('Copyright © Xotric 2023. All Rights Reserved', 'xotric'));
}


/**
 *
 * pagination
 */
if (!function_exists('xotric_pagination')) {

    function _xotric_pagi_callback($pagination)
    {
        return $pagination;
    }

    //page navegation
    function xotric_pagination($prev, $next, $pages, $args)
    {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ($pages == '') {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if (!$pages) {
                $pages = 1;
            }
        }

        $pagination = [
            'base'      => add_query_arg('paged', '%#%'),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ($wp_rewrite->using_permalinks()) {
            $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
        }

        if (!empty($wp_query->query_vars['s'])) {
            $pagination['add_args'] = ['s' => get_query_var('s')];
        }

        $pagi = '';
        if (paginate_links($pagination) != '') {
            $paginations = paginate_links($pagination);
            $pagi .= '<ul class="pagination">';
            foreach ($paginations as $key => $pg) {
                $pagi .= '<li class="page-item">' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _xotric_pagi_callback($pagi);
    }
}


// theme color
function xotric_custom_color()
{

    // Primary Color
    $color_code = get_theme_mod('xotric_color_option', '#7E54F8');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-primary-color: " . $color_code . "}";
        $custom_css .= "html:root { --unit-primary-color: " . $color_code . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }

    // Secondary Color
    $color_code2 = get_theme_mod('xotric_color_option2', '#F85454');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code2 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-secondary-color: " . $color_code2 . "}";
        $custom_css .= "html:root { --unit-secondary-color: " . $color_code2 . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }

    // Third Color
    $color_code3 = get_theme_mod('xotric_color_option3', '#FFC42B');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code3 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-primary-color-three: " . $color_code3 . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }

    // Forth Color
    $color_code4 = get_theme_mod('xotric_color_option4', '#5956E9');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code4 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-primary-color-two: " . $color_code4 . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }

    // Fifth Color
    $color_code5 = get_theme_mod('xotric_color_option5', '#F07707');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code5 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-secondary-color-two: " . $color_code5 . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }

    // Six Color
    $color_code6 = get_theme_mod('xotric_color_option6', '#348A63');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code6 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-green: " . $color_code6 . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }
    // Seven Color
    $color_code7 = get_theme_mod('xotric_color_option7', '#F22556');
    wp_enqueue_style('xotric-custom', XOTRIC_THEME_CSS_DIR . 'xotric-custom.css', []);
    if ($color_code7 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --new-red: " . $color_code7 . "}";
        wp_add_inline_style('xotric-custom', $custom_css);
    }
}
add_action('wp_enqueue_scripts', 'xotric_custom_color');



// xotric_kses_intermediate
function xotric_kses_intermediate($string = '')
{
    return wp_kses($string, xotric_get_allowed_html_tags('intermediate'));
}

function xotric_get_allowed_html_tags($level = 'basic')
{
    $allowed_html = [
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id' => [],
        ];
        $allowed_html['img'] = [
            'src' => [],
            'class' => [],
            'alt' => [],
        ];
        $allowed_html['del'] = [
            'class' => [],
        ];
        $allowed_html['ins'] = [
            'class' => [],
        ];
        $allowed_html['bdi'] = [
            'class' => [],
        ];
        $allowed_html['i'] = [
            'class' => [],
            'data-rating-value' => [],
        ];
    }

    return $allowed_html;
}



// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function xotric_kses($raw)
{

    $allowed_tags = array(
        'a'      => array(
            'class'   => array(),
            'href'    => array(),
            'rel'  => array(),
            'title'   => array(),
            'target' => array(),
        ),
        'abbr'   => array(
            'title' => array(),
        ),
        'b'    => array(),
        'blockquote'   => array(
            'cite' => array(),
        ),
        'cite'   => array(
            'title' => array(),
        ),
        'code'  => array(),
        'del'   => array(
            'datetime'   => array(),
            'title'      => array(),
        ),
        'dd'     => array(),
        'div'    => array(
            'class'   => array(),
            'title'   => array(),
            'style'   => array(),
        ),
        'dl'   => array(),
        'dt'   => array(),
        'em'   => array(),
        'h1'   => array(),
        'h2'   => array(),
        'h3'   => array(),
        'h4'   => array(),
        'h5'   => array(),
        'h6'   => array(),
        'i'    => array(
            'class' => array(),
        ),
        'img'   => array(
            'alt'  => array(),
            'class'   => array(),
            'height' => array(),
            'src'  => array(),
            'width'   => array(),
        ),
        'li'   => array(
            'class' => array(),
        ),
        'ol'   => array(
            'class' => array(),
        ),
        'p'    => array(
            'class' => array(),
        ),
        'q'    => array(
            'cite'    => array(),
            'title'   => array(),
        ),
        'span'  => array(
            'class'   => array(),
            'title'   => array(),
            'style'   => array(),
        ),
        'iframe'   => array(
            'width'        => array(),
            'height'       => array(),
            'scrolling'    => array(),
            'frameborder'  => array(),
            'allow'        => array(),
            'src'          => array(),
        ),
        'strike'  => array(),
        'br'      => array(),
        'strong'    => array(),
        'data-wow-duration'   => array(),
        'data-wow-delay'   => array(),
        'data-wallpaper-options'  => array(),
        'data-stellar-background-ratio'   => array(),
        'ul'   => array(
            'class' => array(),
        ),
        'svg' => array(
            'class' => true,
            'aria-hidden' => true,
            'aria-labelledby' => true,
            'role' => true,
            'xmlns' => true,
            'width' => true,
            'height' => true,
            'viewbox' => true, // <= Must be lower case!
        ),
        'g'     => array('fill' => true),
        'title' => array('title' => true),
        'path'  => array('d' => true, 'fill' => true,),
    );

    if (function_exists('wp_kses')) { // WP is here
        $allowed = wp_kses($raw, $allowed_tags);
    } else {
        $allowed = $raw;
    }

    return $allowed;
}
