<?php

/**
 * Template part for displaying header layout two
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xotric
 */

// Header Settings
$xotric_show_sticky_header = get_theme_mod('xotric_show_sticky_header', false);
$sticky_header = $xotric_show_sticky_header ? 'sticky-header' : 'sticky-default';
$sticky_height = $xotric_show_sticky_header ? '' : 'd-none';

$menu_padding = has_nav_menu('main-menu') ? 'xotric-menu-has-showing' : 'xotric-menu-not-showing';

// Header Right
$xotric_show_header_right = get_theme_mod('xotric_show_header_right', false);

// Header Search
$xotric_show_header_search = get_theme_mod('xotric_show_header_search', false);
$xotric_search_title = get_theme_mod('xotric_search_title', __('... Search Here ...', 'xotric'));

// Header Button
$xotric_show_header_button = get_theme_mod('xotric_show_header_button', false);
$xotric_header_btn_text = get_theme_mod('xotric_header_btn_text', __('Get Started', 'xotric'));
$xotric_header_btn_url = get_theme_mod('xotric_header_btn_url', __('#', 'xotric'));

// Mobile Menu
$xotric_show_mobile_social = get_theme_mod('xotric_show_mobile_social', false);

?>


<!-- header-area -->
<header>
    <div id="header-fixed-height" class="<?php echo esc_attr($sticky_height) ?>"></div>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area menu-area-two <?php echo esc_attr($menu_padding) ?>">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav">
                            <div class="logo">
                                <?php xotric_header_two_logo(); ?>
                            </div>
                            <div class="navbar-wrap main-menu d-none d-lg-flex">
                                <?php xotric_header_menu(); ?>
                            </div>

                            <?php if (!empty($xotric_show_header_right)) : ?>
                                <div class="header-action">
                                    <ul class="list-wrap">

                                        <?php if (!empty($xotric_show_header_search)) : ?>
                                            <li class="header-search">
                                                <a href="#">
                                                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M11.5 21C16.7467 21 21 16.7467 21 11.5C21 6.25329 16.7467 2 11.5 2C6.25329 2 2 6.25329 2 11.5C2 16.7467 6.25329 21 11.5 21Z" stroke="currentcolor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M22 22L20 20" stroke="currentcolor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if (!empty($xotric_show_header_button)) : ?>
                                            <li class="header-btn">
                                                <a href="<?php echo esc_url($xotric_header_btn_url) ?>" class="btn btn-two"><?php echo esc_html($xotric_header_btn_text); ?> <span></span></a>
                                            </li>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if (has_nav_menu('main-menu')) { ?>
                                <div class="mobile-nav-toggler"><i class="fas fa-bars"></i></div>
                            <?php } ?>

                        </nav>
                    </div>

                    <!-- Mobile Menu  -->
                    <div class="mobile-menu">
                        <nav class="menu-box">
                            <div class="close-btn"><i class="fas fa-times"></i></div>
                            <div class="nav-logo">
                                <?php xotric_header_two_logo(); ?>
                            </div>
                            <div class="menu-outer">
                                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                            </div>
                            <?php if (!empty($xotric_show_mobile_social)) : ?>
                                <div class="social-links">
                                    <?php xotric_mobile_social_profiles(); ?>
                                </div>
                            <?php endif; ?>
                        </nav>
                    </div>
                    <div class="menu-backdrop"></div>
                    <!-- End Mobile Menu -->

                </div>
            </div>
        </div>
    </div>

    <?php if (!empty($xotric_show_header_search)) : ?>
        <!-- header-search -->
        <div class="search-popup-wrap" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="search-close">
                <span><i class="fas fa-times"></i></span>
            </div>
            <div class="search-wrap text-center">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <?php if (!empty($xotric_search_title)) : ?>
                                <h2 class="title"><?php echo esc_html($xotric_search_title) ?></h2>
                            <?php endif; ?>
                            <div class="search-form">
                                <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                                    <input class="search-input-field" type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Type keywords here', 'xotric'); ?>">
                                    <button class="search-btn"><i class="fas fa-search"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header-search-end -->
    <?php endif; ?>

</header>
<!-- header-area-end -->